import ui, net, app, grp, wndMgr, chr, playerSettingModule, localeInfo, systemSetting, snd, dbg

PLAYER_SLOT_COUNT = 4

class SelectCharacterWindow(ui.ScriptWindow):

	class CharacterRenderer(ui.Window):
		def OnRender(self):
			grp.ClearDepthBuffer()
			grp.SetGameRenderState()
			grp.PushState()
			grp.SetOmniLight()
			grp.SetViewport(0.5, 0.0, 0.5, 1.0)
			
			app.SetCenterPosition(0.0, 0.0, 0.0)
			app.SetCamera(1550.0, 15.0, 180.0, 95.0)
			grp.SetPerspective(10.0, (float(wndMgr.GetScreenWidth()) / 2.0 / float(wndMgr.GetScreenHeight())), 1000.0, 3000.0)

			(x, y) = app.GetCursorPosition()
			grp.SetCursorPosition(x, y)

			chr.Deform()
			chr.Render()

			grp.RestoreViewport()
			grp.PopState()
			grp.SetInterfaceRenderState()

	def __init__(self, stream = None):
		ui.ScriptWindow.__init__(self)
		net.SetPhaseWindow(net.PHASE_WINDOW_SELECT, self)
		self.stream = stream
		playerSettingModule.LoadGameData("INIT")
		self.__LoadScript("levana_work/code/ui_levana_select.py")
		self.rotation = 0
		self.current_slot = 0
		self.openLoadingFlag = FALSE
		self.startReservingTime = 0
		self.startIndex = -1
		self.Open()
		
	def Open(self):
		self.Show()
		app.ShowCursor()
		self.SetFocus()
		self.__SelectSlot(0)
		self.SetEmpire(net.GetEmpireID())
		
	def Close(self):
		self.stream.popupWindow.Close()
		chr.DeleteInstance(0)
		self.Hide()
		self.KillFocus()
		app.HideCursor()
		self.text_value_vit = None
		self.text_value_int = None
		self.text_value_str = None
		self.text_value_dex = None
		self.text_timevalue = None
		self.text_playername = None
		self.text_kingdomvalue = None
		self.text_slot = None
		
	def SetEmpire(self, id):
		if id == 1:
			self.text_kingdomvalue.SetText("Rotes Reich")
		elif id == 2:
			self.text_kingdomvalue.SetText("Gelbes Reich")
		else:
			self.text_kingdomvalue.SetText("Blaues Reich")

	def __del__(self):
		ui.ScriptWindow.__del__(self)
		net.SetPhaseWindow(net.PHASE_WINDOW_SELECT, 0)

	def __LoadScript(self, fileName):
		try:
			pyLoader = ui.PythonScriptLoader()
			pyLoader.LoadScriptFile(self, fileName)
		except:
			import exception
			exception.Abort("levana_select.py ## __LoadScript.LoadScriptFile")
		try:
			self.gauge_vit		= self.GetChild("gauge_vit")
			self.text_value_vit		= self.GetChild("text_value_vit")
			self.gauge_int		= self.GetChild("gauge_int")
			self.text_value_int		= self.GetChild("text_value_int")
			self.gauge_str		= self.GetChild("gauge_str")
			self.text_value_str		= self.GetChild("text_value_str")
			self.gauge_dex		= self.GetChild("gauge_dex")
			self.text_value_dex		= self.GetChild("text_value_dex")
			self.text_timevalue		= self.GetChild("text_timevalue")
			self.text_guildname		= self.GetChild("text_guildname")
			self.text_kingdomvalue		= self.GetChild("text_kingdomvalue")
			self.text_slot		= self.GetChild("text_slot")
			self.text_playername		= self.GetChild("text_playername")
			self.text_level		= self.GetChild("text_level")
			self.content		= self.GetChild("content")
			self.btn_login		= self.GetChild("btn_login")
			self.btn_create		= self.GetChild("btn_create")
			self.btn_delete		= self.GetChild("btn_delete")
			self.btn_left		= self.GetChild("btn_left")
			self.btn_right		= self.GetChild("btn_right")
			self.img_race		= self.GetChild("img_race")
			self.character_render_window		= self.GetChild("character_render_window")

			self.chrRenderer = self.CharacterRenderer()
			self.chrRenderer.SetParent(self.character_render_window)
			self.chrRenderer.Show()
		except:
			import exception
			exception.Abort("levana_select.py ## __LoadScript.GetChild")
		try:
			self.btn_left.SetEvent(ui.__mem_func__(self.__SelectSlot), -1)
			self.btn_right.SetEvent(ui.__mem_func__(self.__SelectSlot), 1)
			self.btn_login.SetEvent(ui.__mem_func__(self.__Connect))
			self.btn_create.SetEvent(ui.__mem_func__(self.__CreateCharacter))
			self.btn_delete.SetEvent(ui.__mem_func__(self.InputPrivateCode))
		except:
			import exception
			exception.Abort("levana_select.py ## __LoadScript.SetEvent")

	def __Close(self):
		self.stream.SetLoginPhase()
		# app.Exit()
				
	def __Connect(self):
		self.stream.SetCharacterSlot(self.current_slot)
		self.startIndex = self.current_slot
		self.startReservingTime = app.GetTime()
		chr.PushOnceMotion(chr.MOTION_INTRO_SELECTED, 0.1)

	def __MakeCharacter(self, name, race, form, hair):
		chr.CreateInstance(0)
		chr.SelectInstance(0)
		chr.SetVirtualID(0)
		chr.SetNameString(name)

		chr.SetRace(race)
		chr.SetArmor(form)
		chr.SetHair(hair)

		chr.Refresh()
		chr.SetMotionMode(chr.MOTION_MODE_GENERAL)
		chr.SetLoopMotion(chr.MOTION_INTRO_WAIT)

		chr.SetRotation(0.0)
		
	def __SelectSlot(self, direction):
		if (self.current_slot + direction) < 0:
			self.current_slot = PLAYER_SLOT_COUNT - 1
		elif (self.current_slot + direction) >= PLAYER_SLOT_COUNT:
			self.current_slot = 0
 		else:
			self.current_slot += direction
		self.text_slot.SetText("SLOT: |cfffafdff%s" % str(self.current_slot + 1))
		chr.DeleteInstance(0)
		id = net.GetAccountCharacterSlotDataInteger(self.current_slot, net.ACCOUNT_CHARACTER_SLOT_ID)
		if id:
			self.btn_create.Hide()
			self.btn_login.Show()
			
			self.__MakeCharacter(
				net.GetAccountCharacterSlotDataString(self.current_slot, net.ACCOUNT_CHARACTER_SLOT_NAME),
				net.GetAccountCharacterSlotDataInteger(self.current_slot, net.ACCOUNT_CHARACTER_SLOT_RACE),
				net.GetAccountCharacterSlotDataInteger(self.current_slot, net.ACCOUNT_CHARACTER_SLOT_FORM),
				net.GetAccountCharacterSlotDataInteger(self.current_slot, net.ACCOUNT_CHARACTER_SLOT_HAIR),
			)
			time, level, race, vit_v, int_v, str_v, dex_v, name, guild = (
				net.GetAccountCharacterSlotDataInteger(self.current_slot, net.ACCOUNT_CHARACTER_SLOT_PLAYTIME),
				net.GetAccountCharacterSlotDataInteger(self.current_slot, net.ACCOUNT_CHARACTER_SLOT_LEVEL),
				net.GetAccountCharacterSlotDataInteger(self.current_slot, net.ACCOUNT_CHARACTER_SLOT_RACE),
				net.GetAccountCharacterSlotDataInteger(self.current_slot, net.ACCOUNT_CHARACTER_SLOT_HTH),
				net.GetAccountCharacterSlotDataInteger(self.current_slot, net.ACCOUNT_CHARACTER_SLOT_INT),
				net.GetAccountCharacterSlotDataInteger(self.current_slot, net.ACCOUNT_CHARACTER_SLOT_STR),
				net.GetAccountCharacterSlotDataInteger(self.current_slot, net.ACCOUNT_CHARACTER_SLOT_DEX),
				net.GetAccountCharacterSlotDataString(self.current_slot, net.ACCOUNT_CHARACTER_SLOT_NAME),
				net.GetAccountCharacterSlotDataString(self.current_slot, net.ACCOUNT_CHARACTER_SLOT_GUILD_NAME),
			)
		else:
			self.btn_create.Show()
			self.btn_login.Hide()
			time, level, race, vit_v, int_v, str_v, dex_v, name, guild = (0, "-/-", 0, 0, 0, 0, 0, "-/-", "")
		if guild != "":
			self.text_guildname.SetText(guild)
		else:
			self.text_guildname.SetText("-/-")
		self.text_level.SetText(str(level))
		self.text_playername.SetText(name)
		self.text_timevalue.SetText(str(time) + " min.")
		self.text_value_vit.SetText("VIT: " + str(vit_v))
		self.text_value_int.SetText("INT: " + str(int_v))
		self.text_value_str.SetText("STR: " + str(str_v))
		self.text_value_dex.SetText("DEX: " + str(dex_v))
		states_sum = float(vit_v + int_v + str_v + dex_v)
		self.gauge_vit.SetPercentage(vit_v , states_sum)
		self.gauge_int.SetPercentage(int_v , states_sum)
		self.gauge_str.SetPercentage(str_v , states_sum)
		self.gauge_dex.SetPercentage(dex_v , states_sum)
		
		raceImgDict = {
			0 : "levana_work/images/select/img_race_warrior.tga",
			1 : "levana_work/images/select/img_race_ninja.tga",
			2 : "levana_work/images/select/img_race_sura.tga",
			3 : "levana_work/images/select/img_race_shaman.tga",
			4 : "levana_work/images/select/img_race_warrior.tga",
			5 : "levana_work/images/select/img_race_ninja.tga",
			6 : "levana_work/images/select/img_race_sura.tga",
			7 : "levana_work/images/select/img_race_shaman.tga",
		}
		
		self.img_race.LoadImage(raceImgDict[race])
		
	def OnKeyDown(self, key):
		if 203 == key:
			self.__SelectSlot(-1)
		if 205 == key:
			self.__SelectSlot(1)
		if 28 == key:
			id = net.GetAccountCharacterSlotDataInteger(self.current_slot, net.ACCOUNT_CHARACTER_SLOT_ID)
			if 0 == id:
				self.__CreateCharacter()
			else:
				self.__Connect()
		if 1 == key:
			self.stream.SetLoginPhase()

		return TRUE
		
	def __AreAllSlotEmpty(self):
		for i in xrange(PLAYER_SLOT_COUNT):
			if 0!=net.GetAccountCharacterSlotDataInteger(i, net.ACCOUNT_CHARACTER_SLOT_ID):
				return 0
		return 1
		
	def __CreateCharacter(self):
		self.stream.SetCharacterSlot(self.current_slot)
		if self.__AreAllSlotEmpty():
			self.stream.SetReselectEmpirePhase()
		else:
			self.stream.SetCreateCharacterPhase()
			
	def EmptyFunc(self):
		pass
		
	def TestOutput(self, txt):
		import dbg
		dbg.TraceError("TESTOUTPUT :::: %s" % str(txt))
	
	def OnPressExitKey(self):
		app.Exit()
		
	def OnUpdate(self):
		chr.Update()
		chr.SetRotation(self.rotation)
		self.rotation += 0.4
		if self.startIndex != -1:
			if app.GetTime() - self.startReservingTime > 1.0:
				if FALSE == self.openLoadingFlag:
					chrSlot=self.stream.GetCharacterSlot()
					net.DirectEnter(chrSlot)
					self.openLoadingFlag = TRUE

					playTime=net.GetAccountCharacterSlotDataInteger(self.current_slot, net.ACCOUNT_CHARACTER_SLOT_PLAYTIME)

					import player
					player.SetPlayTime(playTime)
					import chat
					chat.Clear()
		
	def InputPrivateCode(self):
		
		import uiCommon
		privateInputBoard = uiCommon.InputDialogWithDescription()
		privateInputBoard.SetTitle(localeInfo.INPUT_PRIVATE_CODE_DIALOG_TITLE)
		privateInputBoard.SetAcceptEvent(ui.__mem_func__(self.AcceptInputPrivateCode))
		privateInputBoard.SetCancelEvent(ui.__mem_func__(self.CancelInputPrivateCode))
		privateInputBoard.SetSecretMode()
		privateInputBoard.SetMaxLength(7)
			
		privateInputBoard.SetBoardWidth(250)
		privateInputBoard.SetDescription(localeInfo.INPUT_PRIVATE_CODE_DIALOG_DESCRIPTION)
		privateInputBoard.Open()
		self.privateInputBoard = privateInputBoard
		
	def AcceptInputPrivateCode(self):
		privateCode = self.privateInputBoard.GetText()
		if not privateCode:
			return

		id = net.GetAccountCharacterSlotDataInteger(self.current_slot, net.ACCOUNT_CHARACTER_SLOT_ID)
		if 0 == id:
			self.PopupMessage(localeInfo.SELECT_EMPTY_SLOT)
			return

		net.SendDestroyCharacterPacket(self.current_slot, privateCode)
		self.PopupMessage(localeInfo.SELECT_DELEING)

		self.CancelInputPrivateCode()
		return TRUE

	def CancelInputPrivateCode(self):
		self.privateInputBoard = None
		return TRUE

	def OnDeleteSuccess(self, slot):
		self.PopupMessage(localeInfo.SELECT_DELETED)
		self.DeleteCharacter(slot)

	def OnDeleteFailure(self):
		self.PopupMessage(localeInfo.SELECT_CAN_NOT_DELETE)

	def DeleteCharacter(self, index):
		chr.DeleteInstance(index)
		self.__SelectSlot(0)
		
	def PopupMessage(self, msg, func=0):
		if not func:
			func=self.EmptyFunc

		self.stream.popupWindow.Close()
		self.stream.popupWindow.Open(msg, func, localeInfo.UI_OK)

